# -*- coding: cp1252 -*-
overrideIcon= "r_renderman_denoise"

######################################################################
#
# Name:  Renderman Denoise
# Author:  Royal Render, Holger Schoenberger, Binary Alchemy
# Version: 
# Description: 
#   Create Job for Renderman Denoise execution
#
#   
# Copyright (c) Holger Schoenberger - Binary Alchemy
######################################################################
import os
import datetime
import sys

scriptpath= rrGlobal.rrRootPath()+"/render_apps/scripts"
scriptpath= scriptpath.replace("\\","/")
sys.path.append(scriptpath)
import rrScriptHelper




#create UI to request redshift file locations
myUI= rrGlobal.getGenericUI()
myUI.addItem(rrGlobal.genUIType.label,"infoLabel","")
myUI.setText("infoLabel","Please load one frame of the sequence to denoise.\nIf you have rendered a variance sequence, then please specify one frame of that sequence as well.")

myUI.addItem(rrGlobal.genUIType.label,"labelMainSequence","")
myUI.setText("labelMainSequence","Main image sequence:")
myUI.addItem(rrGlobal.genUIType.browseFile,"MainSequence","")
myUI.addItem(rrGlobal.genUIType.spacerV,"spacerF","")

myUI.addItem(rrGlobal.genUIType.label,"labelVarSequence","")
myUI.setText("labelVarSequence","Variance image sequence:")
myUI.addItem(rrGlobal.genUIType.browseFile,"VarSequence","")
myUI.addItem(rrGlobal.genUIType.spacerV,"spacerF","")

myUI.addItem(rrGlobal.genUIType.checkBox,"checkFilterLayers","")
myUI.setText("checkFilterLayers","Use Flag: Filter Layers Independently")

myUI.addItem(rrGlobal.genUIType.spacerV,"spacerZ","")

myUI.addItem(rrGlobal.genUIType.layoutH,"btnLayout","")
myUI.addItem(rrGlobal.genUIType.closeButton,"Create Job","btnLayout")
myUI.addItem(rrGlobal.genUIType.closeButton,"Abort","btnLayout")

myUI.execute()
if myUI.value("Create Job") == 0:
    del myUI
    raise rrCleanExit()

mainSequence= myUI.text("MainSequence")
varSequence= myUI.text("VarSequence")
filterCheck= (myUI.value("checkFilterLayers")==1)
del myUI



if (len(varSequence)>1):
    idx = len(varSequence)-1
    while idx > 1:
        if (varSequence[idx].isdigit()):
            break
        idx -= 1   

    while idx > 1:
        if (not varSequence[idx].isdigit()):
            break
        varSequence = varSequence[:idx] + varSequence[idx+1:]
        idx -= 1   
    varSequence= varSequence[:idx+1] + "{<SeqFrameList+-1>}"+ varSequence[idx+1:]

    


#Create the job
renderApp= rrJob._RenderAppBasic()
renderApp.clear()
renderApp.name="prmanDenoise"
renderApp.type="Comp"


newJob=  rr.getNewJob()
newJob.overrideIcon=overrideIcon;
newJob.sceneName=mainSequence;
newJob.renderApp=renderApp
newJob.imageFileName=mainSequence
newJob.splitImageFileInto_DirFileExt(False)
newJob.imageFileName= newJob.imageFileName+ "_filtered"
newJob.uiIsChecked= True
if (filterCheck):
    rr.setSubmitterParameter("COFilterLayers=1~1")
if (len(varSequence)>1):    
    rr.setSubmitterParameter("AdditionalCommandlineParam=1~1~"+varSequence)


rr.jobAll_set(999,newJob);  # If the index of the job is higher than the number of jobs,
                            # then a new job is added to the end of the job list. So I use 999.
